import { StyleSheet } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

export const MyRefundStyle = StyleSheet.create({
    container: {
        flex: 1,
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
        paddingVertical: dpr(20),
    },
    noRefund: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        paddingHorizontal: dpr(54),
        paddingVertical: dpr(50),
    },
    noRefundText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        textAlign: "center",
    },
    lastRefund: {
        flexDirection: "row",
        justifyContent: "space-between",
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        paddingHorizontal: dpr(15),
        paddingVertical: dpr(12),
    },
    variations: {
        marginTop: dpr(5),
        flexDirection: "row",
        alignItems: "center",
    },
    variationsItem: {
        flexDirection: "row",
        alignItems: "center",
    },
    hr: {
        height: 10,
        borderWidth: 0.6,
        borderColor: "#DFDFDF",
        marginHorizontal: 4,
    },
    title: {
        paddingRight: dpr(10),
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(14),
        color: "#2C2C2C",
    },
    text1: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(11),
        color: "#898989",
        marginTop: dpr(11),
        textAlign: 'left'
    },
    text2: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
        marginTop: dpr(3),
        width: dpr("wf") - dpr(150),
        textAlign: 'left'
    },
    attribute: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        color: "#898989",
    },
    imgCont: {
        height: dpr(50),
        width: dpr(50),
        marginTop: dpr(9),
        backgroundColor: "#F3F3F3",
        borderRadius: 4,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    img: {
        height: dpr(35),
        width: dpr(35),
    },
    refundList: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        marginTop: dpr(20),
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        padding: 15,
    },
    listText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
    },
    requestRefund: {
        position: "absolute",
        bottom: dpr(10),
        left: dpr(20),
        right: dpr(20),
        backgroundColor: "#FCCA19",
        borderRadius: 6,
        height: dpr(60),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
    },
    requestRefundLoading: {
        position: "absolute",
        bottom: dpr(6),
        left: dpr(20),
        right: dpr(20),
        backgroundColor: "#FCCA19",
        borderRadius: 6,
    },
    requestText: {
        textAlign: "center",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(18),
        color: "#2C2C2C",
    },
});
